# Get the problem mesh
mesh = problem.mesh()

# Define the function space
vector = VectorFunctionSpace(mesh, "CG", 1)

# Test and trial functions
v = TestFunction(vector)
u = Function(vector)
du = TrialFunction(vector)

# Get forces and boundary conditions
B = problem.body_force()
PN = problem.surface_traction()
bcu = problem.boundary_conditions()

# First Piola-Kirchhoff stress tensor based on the material
# model
P = problem.first_pk_stress(u)

# The variational form corresponding to static hyperelasticity
L = inner(P, Grad(v))*dx - inner(B, v)*dx - inner(PN, v)*ds
a = derivative(L, u, du)

# Setup and solve problem
equation = VariationalProblem(a, L, bcu, nonlinear = True)
equation.solve(u)
