    def SecondPiolaKirchhoffStress(self, u):
        self._construct_local_kinematics(u)
        psi = self.strain_energy(MaterialModel._parameters_as_functions(self, u))

        if self.kinematic_measure == "InfinitesimalStrain":
            epsilon = self.epsilon
            S = diff(psi, epsilon)
        elif self.kinematic_measure == "RightCauchyGreen":
            C = self.C
            S = 2*diff(psi, C)            
        elif self.kinematic_measure ==  "GreenLagrangeStrain":
            E = self.E
            S = diff(psi, E)
        elif self.kinematic_measure == "CauchyGreenInvariants":
            I = self.I; C = self.C
            I1 = self.I1; I2 = self.I2; I3 = self.I3
            gamma1 = diff(psi, I1) + I1*diff(psi, I2)
            gamma2 = -diff(psi, I2)
            gamma3 = I3*diff(psi, I3)
            S = 2*(gamma1*I + gamma2*C + gamma3*inv(C))
        elif self.kinematic_measure == "IsochoricCauchyGreenInvariants":
            I = self.I; Cbar = self.Cbar
            I1bar = self.I1bar; I2bar = self.I2bar; J = self.J
            gamma1bar = diff(psibar, I1bar) + I1bar*diff(psibar, I2bar)
            gamma2bar = -diff(psibar, I2bar)
            Sbar = 2*(gamma1bar*I + gamma2bar*C_bar)
